@extends($activeTemplate.'layouts.frontend')
@section('content')
<section class="pt-120 pb-120 border-top-1">
    <div class="container">
        <div class="row justify-content-center mb-none-30">
          @foreach($blogs as $blog)
            <div class="col-lg-4 col-md-6 mb-30 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                <div class="blog-card h-100">
                    <div class="blog-card__thumb">
                    <img src="{{ getImage('assets/images/frontend/blog/thumb_' . $blog->data_values->blog_image, '390x210') }}" alt="image">
                    </div>
                    <div class="blog-card__content">
                    <ul class="blog-card__meta d-flex flex-wrap mb-2">
                        <li>
                        <i class="las la-calendar"></i>
                        <span>{{ showDateTime($blog->created_at,'d M Y') }}</span>
                        </li>
                    </ul>
                    <h4 class="blog-card__title mb-4"><a href="{{ route('blog.details', [slug($blog->data_values->title), $blog->id]) }}">{{ __($blog->data_values->title) }}</a></h4>
                    <p>{{ __($blog->data_values->short_description) }}</p>
                    <a href="{{ route('blog.details', [slug($blog->data_values->title), $blog->id]) }}" class="btn btn-sm btn--base mt-4">@lang('Read More')</a>
                    </div>
                </div>
            </div>
          @endforeach
      </div>
        @if ($blogs->hasPages())
            <div class="d-flex justify-content-center">
                {{ paginateLinks($blogs) }}
            </div>
        @endif
    </div>
    </section>


    @if($sections->secs != null)
      @foreach(json_decode($sections->secs) as $sec)
          @include($activeTemplate.'sections.'.$sec)
      @endforeach
    @endif



@endsection

