@extends($activeTemplate.'layouts.frontend')
@section('content')
@php
   $contactContent = getContent('contact_us.content',true);
   $user = auth()->user();
@endphp

<div class="container">
    <section class="pt-120 pb-120">
        <div class="container">
          <div class="row">
            <div class="col-lg-6">
              <span class="subtitle fw-bold text--base font-size--18px">{{ __($contactContent->data_values->subheading) }}</span>
              <h2 class="section-title">{{ __($contactContent->data_values->heading) }}</h2>
              <ul class="contact-info-list mt-5">
                <li class="single-info d-flex flex-wrap align-items-center">
                  <div class="single-info__icon bg--base text-white d-flex justify-content-center align-items-center rounded-3">
                    <i class="las la-map-marked-alt"></i>
                  </div>
                  <div class="single-info__content">
                    <h4 class="title">@lang('Our Address')</h4>
                    <p class="mt-3">{{ __($contactContent->data_values->address) }}</p>
                  </div>
                </li><!-- single-info end -->
                <li class="single-info d-flex flex-wrap align-items-center">
                  <div class="single-info__icon bg--base text-white d-flex justify-content-center align-items-center rounded-3">
                    <i class="las la-envelope"></i>
                  </div>
                  <div class="single-info__content">
                    <h4 class="title">@lang('Email Address')</h4>
                    <p class="mt-3"><a href="mailto:{{ $contactContent->data_values->email }}" class="text--secondary">{{ $contactContent->data_values->email }}</a></p>
                  </div>
                </li><!-- single-info end -->
                <li class="single-info d-flex flex-wrap align-items-center">
                  <div class="single-info__icon bg--base text-white d-flex justify-content-center align-items-center rounded-3">
                    <i class="las la-phone-volume"></i>
                  </div>
                  <div class="single-info__content">
                    <h4 class="title">@lang('Phone Number')</h4>
                    <p class="mt-3"><a href="tel:{{ $contactContent->data_values->phone }}" class="text--secondary">{{ $contactContent->data_values->phone }}</a></p>
                  </div>
                </li><!-- single-info end -->
              </ul>
            </div>
            <div class="col-lg-6 mt-lg-0 mt-5">
              <form method="post" action="" class="p-sm-5 p-3 section--bg rounded-3 position-relative verify-gcaptcha">
                @csrf
                <div class="row">
                  <div class="form-group col-lg-12">
                    <label>@lang('Name')</label>
                    <input type="text" name="name" class="form-control" value="@if($user){{ $user->fullname }} @else{{ old('name') }}@endif" @if($user) readonly @endif required>
                  </div>
                  <div class="form-group col-lg-12">
                    <label>@lang('Email')</label>
                    <input type="text" name="email" class="form-control" value="@if($user){{ $user->email }}@else{{  old('email') }}@endif" @if($user) readonly @endif required>
                  </div>
                  <div class="form-group col-lg-12">
                    <label>@lang('Subject')</label>
                    <input type="text" name="subject" class="form-control" value="{{old('subject')}}" required>
                  </div>
                  <div class="form-group col-lg-12">
                    <label>@lang('Message')</label>
                    <textarea name="message" wrap="off" class="form-control" required>{{old('message')}}</textarea>
                  </div>
                  <div class="form-group col-lg-12">
                    <x-captcha />
                  </div>
                  <div class="col-lg-12">
                    <button type="submit" class="btn btn--base w-100">@lang('Submit Now')</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </section>
</div>
@endsection
