@php
    if (Route::currentRouteName() != 'plans'){
        $showViewMoreBtn = $plans->count() > 8;
        $plans           = $plans->limit(8)->get();
    }
@endphp
<div class="row justify-content-center mb-none-70">
    @foreach ($plans as $plan)
        <div class="col-xl-3 col-lg-4 col-sm-6 mb-70 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.1s">
            <div class="package-card text-center bg_img" style="background-image: url('{{ getImage($activeTemplateTrue . 'images/plan.jpg', '770x945') }}');">
                <h4 class="package-card__title">{{ __($plan->name) }}</h4>
                <div class="package-card__range mt-4 base--color">{{ curSym() }}{{ showAmount($plan->fixed_amount) }}</div>
                <ul class="package-card__features mt-3">
                    <li>@lang('Return') {{ showAmount($plan->interest) }}%</li>
                    <li>@lang('For a') {{ __($plan->time->name) }}</li>
                    <li>@lang('Total') {{ ($plan->fixed_amount * $plan->interest) / 100 }} {{ curText() }} + <span class="badge badge--base">@lang('Capital')</span>
                    </li>
                </ul>
                <button data-bs-toggle="modal" data-bs-target="#investModal" data-plan="{{ $plan }}" class="btn btn-md btn--base mt-4 investModal" type="button">@lang('Invest Now')</button>
            </div>
        </div>
    @endforeach
</div>

@if (@$showViewMoreBtn)
    <div class="row mt-50">
        <div class="col-lg-12 text-center">
            <a href="{{ route('plans') }}" class="btn btn--base">@lang('View All Plans')</a>
        </div>
    </div>
@endif
