@php
   $contactContent = getContent('contact_us.content', true);
@endphp

<div class="header__top">
    <div class="container">
      <div class="row">
        <div class="col-md-6">
          <ul class="header-info-list justify-content-md-start justify-content-center">
            <li>
              <a href="tel:{{$contactContent->data_values->phone }}"><i class="las la-headset"></i> {{ $contactContent->data_values->phone }}</a>
            </li>
            <li>
              <a href="mailto:{{$contactContent->data_values->email }}"><i class="las la-envelope"></i> {{ $contactContent->data_values->email }}</a>
            </li>
          </ul>
        </div>
        <div class="col-md-6">
          <div class="d-flex justify-content-md-end justify-content-center align-items-center">
            @if($general->multi_language)
            <select class="language-select mr-3 langSel d-none d-md-block">
              @foreach($language as $item)
                  <option value="{{ $item->code }}" @if(session('lang')==$item->code) selected @endif>{{ __($item->name) }}</option>
              @endforeach
            </select>
            @endif

            @guest
            <ul class="header-info-list justify-content-end">
              <li class="d-none d-md-block">
                <a href="{{ route('user.login') }}"><i class="las la-user"></i> @lang('Login') </a>
              </li>
              @if($general->registration)
              <li class="d-none d-md-block">
                <a href="{{ route('user.register') }}"><i class="las la-sign-in-alt"></i> @lang('Registration') </a>
              </li>
              @endif
            </ul>
            @else
            <ul class="header-info-list justify-content-end">
                <li>
                  <a href="{{ route('user.logout') }}"><i class="las la-sign-out-alt"></i> @lang('Logout') </a>
                </li>
            </ul>
            @endguest
          </div>
        </div>
      </div>
    </div>
  </div>
