<?php

namespace App\Http\Controllers\Admin;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\Plan;
use App\Models\TimeSetting;
use Illuminate\Http\Request;

class PlanController extends Controller
{
    public function index()
    {
        $pageTitle = "Plans";
        $plans     = Plan::orderBy('fixed_amount', 'ASC')->with('time')->get();
        $times     = TimeSetting::active()->get();
        return view('admin.plan.index', compact('pageTitle', 'plans', 'times'));
    }

    public function store(Request $request)
    {
        $this->validation($request);

        $plan = new Plan();
        $this->saveData($plan, $request);

        $notify[] = ['success', 'Plan added successfully'];
        return back()->withNotify($notify);
    }

    public function update(Request $request, $id)
    {
        $this->validation($request);

        $plan = Plan::findOrFail($id);
        $this->saveData($plan, $request);

        $notify[] = ['success', 'Plan updated successfully'];

        return back()->withNotify($notify);
    }

    protected function saveData($plan, $request)
    {
        $time                = TimeSetting::where('id', $request->time_id)->firstOrFail();

        $plan->time_id       = $time->id;
        $plan->name          = $request->name;
        $plan->fixed_amount  = $request->amount;
        $plan->interest      = $request->interest;
        $plan->featured      = $request->featured ? Status::YES : Status::NO;
        $plan->save();
    }

    protected function validation($request)
    {
        $request->validate([
            'name'     => 'required',
            'amount'   => 'required|gt:0',
            'interest' => 'required|numeric|gt:0',
            'time_id'     => 'required|integer|gt:0',
            'featured' => 'nullable',
        ]);
    }

    public function status($id)
    {
        return Plan::changeStatus($id);
    }

}
