<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\TimeSetting;
use Illuminate\Http\Request;

class TimeSettingController extends Controller
{
    public function index()
    {
        $pageTitle = "Manage Time Settings";
        $times     = TimeSetting::orderBy('time','ASC')->get();
        return view('admin.time_setting.index', compact('pageTitle', 'times'));
    }

    public function store(Request $request, $id=0)
    {
        $request->validate([
            'name' => 'required',
            'time' => 'required|integer|min:0',
        ]);

        if($id){
            $time = TimeSetting::findOrFail($id);
            $notify[] = ['success', 'Time schedule updated successfully'];
        }else{
            $time = new TimeSetting();
            $notify[] = ['success', 'Time schedule added successfully'];
        }

        $time->name = $request->name;
        $time->time = $request->time;
        $time->save();

        return back()->withNotify($notify);
    }
    public function status($id)
    {
        return TimeSetting::changeStatus($id);
    }
}
