@extends('admin.layouts.app')
@section('panel')
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th>@lang('Name')</th>
                                    <th>@lang('Invest Amount')</th>
                                    <th>@lang('Interest')</th>
                                    <th>@lang('Time')</th>
                                    <th>@lang('Status')</th>
                                    <th>@lang('Featured')</th>
                                    <th>@lang('Action')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($plans as $plan)
                                    <tr>
                                        <td>{{ __($plan->name) }}</td>
                                        <td>
                                            <span>{{ curSym() }}{{ showAmount($plan->fixed_amount) }}</span>
                                        </td>
                                        <td> {{ showAmountTwoDigit($plan->interest) }}% </td>
                                        <td>{{ __($plan->time->name) }}</td>
                                        <td> @php echo $plan->statusBadge; @endphp </td>
                                        <td> @php echo $plan->featuredBadge; @endphp </td>
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-sm btn-outline--primary modalShow me-2" data-type="edit" data-bs-toggle="modal" data-bs-target="#planModal" data-resource="{{ $plan }}" data-action="{{ route('admin.plan.update', $plan->id) }}"><i class="las la-pen"></i>@lang('Edit')</button>
                                                @if ($plan->status)
                                                    <button class="btn btn-sm btn-outline--danger confirmationBtn" data-question="@lang('Are you sure to disable this plan?')" data-action="{{ route('admin.plan.status', $plan->id) }}"><i class="las la-eye-slash"></i>@lang('Disable')</button>
                                                @else
                                                    <button class="btn btn-sm btn-outline--success confirmationBtn" data-question="@lang('Are you sure to enable this plan?')" data-action="{{ route('admin.plan.status', $plan->id) }}"><i class="las la-eye"></i>@lang('Enable')</button>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="planModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <label>@lang('Name')</label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        <div class="form-group">
                            <label class="required">@lang('Invest Amount')</label>
                            <div class="input-group">
                                <input type="number" step="any" class="form-control" name="amount" value="" required>
                                <span class="input-group-text">{{ curText() }}</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>@lang('Interest')</label>
                            <div class="input-group">
                                <input type="number" step="any" class="form-control" name="interest" required>
                                <span class="input-group-text">%</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>@lang('Time')</label>
                            <select name="time_id" class="form-control" required>
                                <option value="">@lang('Select One')</option>
                                @foreach ($times as $time)
                                    <option value="{{ $time->id }}">{{ __($time->name) }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label>@lang('Featured')</label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-height="35" data-on="@lang('Featured')" data-off="@lang('Not Featured')" name="featured" checked>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45">@lang('Submit')</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <x-confirmation-modal />
@endsection
@push('breadcrumb-plugins')
    <button class="btn btn-outline--primary btn-sm modalShow" data-type="add" data-bs-toggle="modal" data-bs-target="#planModal" data-action="{{ route('admin.plan.store') }}">
        <i class="las la-plus"></i> @lang('Add New')
    </button>
@endpush


@push('script')
    <script>
        (function($) {
            "use strict"

            $('.modalShow').on('click', function() {
                var btn = $(this);
                var modal = $('#planModal');
                var resource = btn.data('resource');
                var action = btn.data('action');

                modal.find('form')[0].reset();
                modal.find('form').attr('action', btn.data('action'));

                if ($(this).data('type') == 'edit') {
                    modal.find('[name=name]').val(resource.name);
                    modal.find('[name=amount]').val(parseFloat(resource.fixed_amount));
                    modal.find('[name=interest]').val(parseFloat(resource.interest));
                    modal.find('[name=time_id]').val(resource.time_id);
                    modal.find('[name="featured"]').bootstrapToggle(resource.featured == 1 ? "on" : "off" );
                    modal.find('.modal-title').text(`@lang('Edit Plan')`);
                } else {
                    modal.find('.modal-title').text(`@lang('Add New Plan')`);
                }
            });
        })(jQuery);
    </script>
@endpush
