<!doctype html>
<html lang="{{ config('app.locale') }}" itemscope itemtype="http://schema.org/WebPage">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> {{ $general->siteName(__($pageTitle)) }}</title>
    @include('partials.seo')

    <link rel="stylesheet" href="{{ asset('assets/global/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/global/css/all.min.css') }} ">
    <link rel="stylesheet" href="{{ asset('assets/global/css/line-awesome.min.css') }} ">

    <link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/vendor/animate.min.css') }} ">
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/vendor/dots.css') }} ">
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/main.css') }} ">
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/custom.css') }}">

    @stack('style-lib')
    @stack('style')
    <link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/color.php') }}?color={{ $general->base_color }}">
</head>

<body>
    @include($activeTemplate.'partials.loader')
    <div class="page-wrapper">
        @include($activeTemplate.'partials.user_header')
        @include($activeTemplate.'partials.breadcrumb')
        @yield('content')
    </div>

    @include($activeTemplate.'partials.footer')

    <script src="{{asset('assets/global/js/jquery-3.6.0.min.js')}}"></script>
    <script src="{{asset('assets/global/js/bootstrap.bundle.min.js')}}"></script>

    <script src="{{ asset($activeTemplateTrue.'js/vendor/wow.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue.'js/vendor/TweenMax.min.js') }}"></script>
    <script src="{{ asset($activeTemplateTrue.'js/app.js') }}"></script>

    @stack('script-lib')
    @include('partials.notify')
    @include('partials.plugins')
    @stack('script')
    <script>
        (function ($) {
            "use strict";
            @if($general->multi_language)
            $(".langSel").on("change", function () {
                window.location.href = "{{ route('home') }}/change/" + $(this).val();
            });
            @endif
        })(jQuery);
    </script>


    <script>
        (function ($) {
            "use strict";
            $('form').on('submit', function () {
                if ($(this).valid()) {
                    $(':submit', this).attr('disabled', 'disabled');
                }
            });

            var inputElements = $('[type=text],[type=password],select,textarea');
            $.each(inputElements, function (index, element) {
                element = $(element);
                element.closest('.form-group').find('label').attr('for',element.attr('name'));
                element.attr('id',element.attr('name'))
            });
            $.each($('input, select, textarea'), function (i, element) {
                if (element.hasAttribute('required')) {
                    $(element).closest('.form-group').find('label').addClass('required');
                }
            });

            $('.showFilterBtn').on('click',function(){
                $('.responsive-filter-card').slideToggle();
            });

            Array.from(document.querySelectorAll('table')).forEach(table => {
                let heading = table.querySelectorAll('thead tr th');
                Array.from(table.querySelectorAll('tbody tr')).forEach((row) => {
                    Array.from(row.querySelectorAll('td')).forEach((colum, i) => {
                        colum.setAttribute('data-label', heading[i].innerText)
                    });
                });
            });

        })(jQuery);
    </script>
</body>
</html>
