<header class="header">
    @include($activeTemplate.'partials.top_header')
    <div class="header__bottom">
      <div class="container">
        <nav class="navbar navbar-expand-xl p-0 align-items-center">
          <a class="site-logo site-title" href="{{ route('home') }}"><img src="{{ getImage(getFilePath('logoIcon').'/logo.png') }}" alt="site-logo"></a>
          <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="@lang('Toggle navigation')">
            <div class="navbar-toggler__icon">
                <i class="las la-bars"></i>
            </div>
          </button>
          <div class="collapse navbar-collapse justify-content-end" id="navbarSupportedContent">
            <ul class="navbar-nav main-menu ml-auto">
                <li>
                    <a class="{{ menuActive('home') }}" href="{{ route('home') }}">@lang('Home')</a>
                </li>
                <li>
                    <a class="{{ menuActive('plans') }}" href="{{ route('plans') }}">@lang('Plans')</a>
                </li>
                @foreach ($pages as $data)
                <li>
                    <a class="{{ menuActive('pages', [$data->slug]) }}" href="{{ route('pages', [$data->slug]) }}">{{ __($data->name) }}</a>
                </li>
                @endforeach

                <li class="nav-item">
                    <a class="{{ menuActive(['blogs','blog.details']) }}" href="{{ route('blogs') }}">@lang('Blogs')</a>
                </li>
                <li class="nav-item">
                    <a class="{{ menuActive('contact') }}" href="{{ route('contact') }}">@lang('Contact')</a>
                </li>
            </ul>
            @auth
                <div class="nav-right">
                    <a href="{{ route('user.home') }}" class="btn btn-md btn--base">@lang('Dashboard')</a>
                </div>
            @else
                <div class="nav-right d-block d-md-none d-flex justify-content-between">
                    <a href="{{ route('user.login') }}" class="btn btn-md btn--base">@lang('Login')</a>
                    @if($general->multi_language)
                    <select class="language-select mr-3 langSel ">
                      @foreach($language as $item)
                          <option value="{{ $item->code }}" @if(session('lang')==$item->code) selected @endif>{{ __($item->name) }}</option>
                      @endforeach
                    </select>
                    @endif
                </div>
            @endauth
          </div>
        </nav>
      </div>
    </div><!-- header__bottom end -->
</header>
