@php
    $plans           = \App\Models\Plan::active()->with('time')->featured()->orderBy('fixed_amount', 'ASC');
    $plansContent    = getContent('plans.content', true);
    $gatewayCurrency = null;

    if (auth()->check()) {
        $gatewayCurrency = App\Models\GatewayCurrency::whereHas('method', function ($gate) {
            $gate->where('status', Status::ENABLE);
        })
        ->with('method')
        ->orderby('method_code')
        ->get();
    }
@endphp
<section class="pt-120 pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 text-center">
                <div class="section-header pb-60">
                    <h2 class="section-title text--base">{{ __($plansContent->data_values->heading) }}</h2>
                    <p>{{ __($plansContent->data_values->subheading) }}</p>
                </div>
            </div>
        </div>
        @include($activeTemplate.'partials.plans')
    </div>
</section>

@include($activeTemplate.'partials.plans_modal')

