@php
    $profitCalculatorContent = getContent('profit_calculator.content', true);
    $plans = App\Models\Plan::active()->get();
@endphp
    <section class="calculator-section pt-120 pb-120">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-6 pe-lg-5">
                    <h2 class="section-title text--base">{{ __(@$profitCalculatorContent->data_values->heading) }}</h2>
                    <p class="mt-2">{{ __(@$profitCalculatorContent->data_values->subheading) }}</p>
                    <ul class="cmn-list mt-4">
                        <li>
                            <h5 class="text-white">{{ __(@$profitCalculatorContent->data_values->service_one_title) }}</h5>
                            <p class="para-white mt-2">{{ __(@$profitCalculatorContent->data_values->subheading) }}</p>
                        </li>
                        <li>
                            <h5 class="text-white">{{ __(@$profitCalculatorContent->data_values->service_two_title) }}</h5>
                            <p class="para-white mt-2">{{ __(@$profitCalculatorContent->data_values->subheading) }}</p>
                        </li>
                    </ul>
                </div>
                <div class="col-lg-6">
                    <div class="calculator-box">
                        <h2 class="calculator-box__title">@lang('Calculate Your Profit')</h3>
                            <div class="calculator-box__calculate">
                                <div class="form-group">
                                    <label for="invest">@lang('Plans')</label>
                                    <select name="plan_id">
                                        @foreach ($plans as $plan)
                                            <option data-plan="{{ $plan }}">{{ $plan->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="invest">@lang('You Invest')</label>
                                    <div class="input--group">
                                        <input type="number" step="any" name="invest" placeholder="You Invest" class="form-control" value="{{ showAmount($plans->first()->fixed_amount) }}" id="invest" readonly="readonly">
                                        <span class="input-icon"><i class="fab fa-bitcoin"></i></span>
                                    </div>
                                </div>
                            </div>
                            <div class="calculator-box__content">
                                <div class="calculator-widget-wrapper">
                                    <div class="calculator-widget">
                                        <div class="calculator-widget__icon">
                                            <img src="{{ asset($activeTemplateTrue.'images/profit_calculator/business-and-finance.svg') }}" alt="">
                                        </div>
                                        <div class="calculator-widget__content">
                                            <span class="calculator-widget__title">@lang('Invest')</span>
                                            <h4 class="fixed-type">{{ curSym() }}<span class="fixed_amo">{{ showAmount($plans->first()->fixed_amount) }}</h4>
                                        </div>
                                    </div>
                                    <div class="calculator-widget">
                                        <div class="calculator-widget__icon">
                                            <img src="{{ asset($activeTemplateTrue.'images/profit_calculator/return-on-investment.svg') }}" alt="">
                                        </div>
                                        <div class="calculator-widget__content">
                                            <span class="calculator-widget__title">@lang('With Capital')</span>
                                            <h4 class="calculator-widget__amount">@lang('Yes')</h4>
                                        </div>
                                    </div>
                                    <div class="calculator-widget">
                                        <div class="calculator-widget__icon">
                                            <img src="{{ asset($activeTemplateTrue.'images/profit_calculator/profits.svg') }}" alt="">
                                        </div>
                                        <div class="calculator-widget__content">
                                            <span class="calculator-widget__title">@lang('Net profit')</span>
                                            <h4 class="calculator-widget__amount net_profit">{{ curSym() }}{{ showAmount(($plans->first()->fixed_amount * $plans->first()->interest) / 100) }}</h4>
                                        </div>
                                    </div>
                                    <div class="calculator-widget">
                                        <div class="calculator-widget__icon">
                                            <img src="{{ asset($activeTemplateTrue.'images/profit_calculator/profit.svg') }}" alt="">
                                        </div>
                                        <div class="calculator-widget__content">
                                            <span class="calculator-widget__title">@lang('Total Income')</span>
                                            <h4 class="calculator-widget__amount total_profit">{{ curSym() }}{{ showAmount(($plans->first()->fixed_amount * $plans->first()->interest) / 100 + $plans->first()->fixed_amount) }}</h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    @push('script')
        <script>

            function makeDecimal(number) {
                var strippedValue = number.toFixed("{{ $general->allow_decimal_after_number }}");
                return strippedValue;
            }



            $('select[name="plan_id"]').change(function(e) {
                var plan = $(this).find(':selected').data('plan');

                var amount = parseFloat(plan.fixed_amount);
                var interestPercentage = parseFloat(plan.interest);
                var interest = (amount * interestPercentage) / 100;
                total = amount + interest;

                amount = makeDecimal(amount);
                interest = makeDecimal(interest);
                total = makeDecimal(total);


                $('input[name="invest"]').val(amount)
                $('.fixed_amo').text(amount)
                $('.net_profit').text("{{ curSym() }}" + interest)
                $('.total_profit').text("{{ curSym() }}" + total)
            });
        </script>
    @endpush
