@php
   $topInvestorContent = getContent('top_investor.content', true);
   $topInvestorElements = getContent('top_investor.element', false)->sortByDesc('data_values.investment_amount');
@endphp

<section class="pt-120 pb-120">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-xl-6 col-lg-8 text-center">
          <div class="section-header">
            <h2 class="section-title text--base">{{ __($topInvestorContent->data_values->heading) }}</h2>
            <p>{{ __($topInvestorContent->data_values->subheading) }}</p>
          </div>
        </div>
      </div><!-- row end -->
      <div class="row justify-content-center mb-none-30">
        @foreach ($topInvestorElements as $element)
        <div class="col-xl-2 col-md-4 col-sm-6 mb-30 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.1s">
          <div class="investor-card">
            <div class="investor-card__thumb">
              <img src="{{ getImage('assets/images/frontend/top_investor/' . $element->data_values->client_image, '500x500') }}" alt="image">
            </div>
            <div class="investor-card__content">
              <h6 class="name">{{ __($element->data_values->client_name) }}</h6>
              <span class="amount f-size-14">@lang('Investment') - {{ curSym() }}{{ __($element->data_values->investment_amount) }}</span>
            </div>
          </div><!-- investor-card end -->
        </div>
        @endforeach
      </div>
    </div>
  </section>
