@extends($activeTemplate.'layouts.frontend')

@section('content')
@php
   $loginContent = getContent('login.content', true);
@endphp
<section class="pt-120 pb-120">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-12">
          <div class="account-wrapper">
            <div class="left bg_img" style="background-image: url('{{ getImage('assets/images/frontend/login/' . $loginContent->data_values->image, '990x560') }}');">
            </div>
            <div class="right">
              <div class="inner">
                <div class="text-center">
                  <h2 class="title">@lang('Login') </h2>
                </div>
                <form method="POST" action="{{ route('user.login') }}" class="account-form mt-5 verify-gcaptcha">
                    @csrf
                    <div class="form-group">
                        <label>@lang('Username or Email')</label>
                        <input type="text" name="username" value="{{ old('username') }}" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label>@lang('Password')</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>
                    <x-captcha />
                    <div class="form-group form-check">
                        <input class="form-check-input" type="checkbox" name="remember" id="remember"
                            {{ old('remember') ? 'checked' : '' }}>
                        <label class="form-check-label" for="remember">
                                @lang('Remember Me')
                        </label>
                    </div>
                  <div class="form-group">
                    <button type="submit" id="recaptcha" class="btn btn--base w-100">@lang('Login')</button>
                  </div>
                </form>

                @if($general->registration)
                <p class="font-size--14px text-center">@lang('Don\'t have any account?') <a href="{{ route('user.register') }}" class="text--base">@lang('Register').</a></p>
                @endif
                <p class="font-size--14px text-center mt-3"><a href="{{ route('user.password.request') }}" class="text--base">@lang('Forgot your password?').</a></p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
@endsection
