@extends($activeTemplate . 'layouts.master')
@section('content')
<div class="container py-60">
    <div class="row gy-4">
        @if (auth()->user()->kv == 0)
        <div class="col-12">
            <div class="card custom--card">
                <div class="card-header">
                    <h4 class="text-danger">@lang('KYC Verification required')</h4>
                </div>
                <div class="card-body">
                    <p class="mb-0"> @php echo nl2br($kyc->data_values->kyc_required_message) @endphp <a class="text--base" href="{{ route('user.kyc.form') }}">@lang('Click Here to Verify')</a></p>
                </div>
            </div>
        </div>
        @endif
        @if (auth()->user()->kv == 2)
        <div class="col-12">
            <div class="card custom--card">
                <div class="card-header">
                   <h4 class="text-warning">@lang('KYC Verification pending')</h4>
                </div>
                <div class="card-body">
                    <p class="mb-0">@php echo nl2br($kyc->data_values->kyc_pending_message) @endphp <a class="text--base" href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a></p>
                </div>
            </div>
        </div>
        @endif
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.transactions') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['balance']) }}</h4>
                        <span class="caption">@lang('Wallet Balance')</span>
                    </div>
                    <div class="icon">
                        <i class="las la-wallet"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.deposit.history') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['total_deposit']) }}</h4>
                        <span class="caption">@lang('Total Deposit')</span>
                    </div>
                    <div class="icon">
                        <i class="fas fa-hand-holding-usd"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.withdraw.history') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['total_withdraw']) }}</h4>
                        <span class="caption">@lang('Total Withdraw')</span>
                    </div>
                    <div class="icon">
                        <i class="las la-cloud-download-alt"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.referrals') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['referral_commission']) }}</h4>
                        <span class="caption">@lang('Referral Earnings')</span>
                    </div>
                    <div class="icon">
                        <i class="las la-user-friends"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.invest.log') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['total_invest']) }}</h4>
                        <span class="caption">@lang('Total Invest')</span>
                    </div>
                    <div class="icon">
                        <i class="las la-cubes "></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.invest.log') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAMount($data['total_running_invest']) }}</h4>
                        <span class="caption">@lang('Total Running Invest')</span>
                    </div>
                    <div class="icon">
                        <i class="las la-spinner"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.invest.log') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['total_completed_invest']) }}</h4>
                        <span class="caption">@lang('Total Invest Completed') </span>
                    </div>
                    <div class="icon">
                        <i class="las la-list-alt"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.invest.log') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['total_profit']) }}</h4>
                        <span class="caption">@lang('Total Profit') +  <span class="badge badge--base">@lang('Capital')</span> </span>
                    </div>
                    <div class="icon">
                        <i class="las la-money-bill-wave-alt"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        <div class="col-lg-12">
            <div class="table-responsive--md  table-responsive">
                <h4 class="mb-2 ms-1">@lang('Latest Transaction')</h4>
                <table class="table style--two">
                    <thead>
                        <tr>
                            <th>@lang('Trx')</th>
                            <th>@lang('Transacted')</th>
                            <th>@lang('Amount')</th>
                            <th>@lang('Post Balance')</th>
                            <th>@lang('Detail')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $trx)
                            <tr>
                                <td>
                                    <strong>{{ $trx->trx }}</strong>
                                </td>

                                <td>
                                    {{ showDateTime($trx->created_at) }}
                                </td>

                                <td class="budget">
                                    <span class="fw-bold @if ($trx->trx_type == '+') text-success @else text-danger @endif">
                                        {{ $trx->trx_type }} {{ showAmount($trx->amount) }} {{ curText() }}
                                    </span>
                                </td>

                                <td class="budget">
                                    {{ showAmount($trx->post_balance) }} {{ __(curText()) }}
                                </td>


                                <td>
                                    {{ __($trx->details) }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
