<?php

namespace App\Http\Controllers\User;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Http\Controllers\Gateway\PaymentController;
use App\Lib\PlanInvest;
use App\Models\Gateway;
use App\Models\GatewayCurrency;
use App\Models\Invest;
use App\Models\Plan;
use Illuminate\Http\Request;

class InvestController extends Controller
{
    public function invest(Request $request)
    {
        $request->validate([
            'amount'        => 'required|min:0',
            'plan_id'       => 'required',
            'wallet_type'   => 'required',
        ]);

        $user   = auth()->user();
        $plan   = Plan::active()->findOrFail($request->plan_id);
        $amount = $request->amount;

        if ($amount != $plan->fixed_amount) {
            $notify[] = ['error','Please check the investment limit'];
            return back()->withNotify($notify);
        }

        $wallet = $request->wallet_type;

        //Direct checkout
        if ($wallet != 'balance') {

            $gate = GatewayCurrency::whereHas('method', function ($gate) {
                $gate->where('status',Status::ENABLE);
            })->find($request->wallet_type);

            if (!$gate) {
                $notify[] = ['error', 'Invalid gateway'];
                return back()->withNotify($notify);
            }

            if ($gate->min_amount > $request->amount || $gate->max_amount < $request->amount) {
                $notify[] = ['error', 'Please follow deposit limit'];
                return back()->withNotify($notify);
            }

            $data = PaymentController::insertDeposit($gate,$request->amount,$plan);
            session()->put('Track', $data->trx);
            return to_route('user.deposit.confirm');
        }

        if ($request->amount > $user->balance) {
            $notify[] = ['error', 'Your balance is not sufficient'];
            return back()->withNotify($notify);
        }

        $planInvest = new PlanInvest($user, $plan);
        $planInvest->invest($amount);

        $notify[] = ['success','Invested to plan successfully'];
        return back()->withNotify($notify);
    }

    public function log()
    {
        $pageTitle = 'Invest Logs';
        $invests = Invest::where('user_id',auth()->id())->orderBy('id','desc')->with('plan')->paginate(getPaginate());
        return view($this->activeTemplate.'user.invests',compact('pageTitle','invests'));
    }
}
