<?php

namespace App\Models;

use App\Traits\Searchable;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use Searchable;

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function scopeUserTransactions($query)
    {
        return $query->where('user_id', auth()->user()->id);
    }

}
