@extends($activeTemplate.'layouts.frontend')
@section('content')
<section class="pt-150 pb-150">
	<div class="container">
	  <div class="row">
		<div class="col-lg-8">
		  <div class="blog-details-area">
			<div class="blog-details-thumb">
			  <img src="{{ getImage('assets/images/frontend/blog/' . $blog->data_values->blog_image, '820x450') }}" alt="image" class="w-100">
			</div>
			<div class="blog-details-content">
			  <h3 class="blog-details-title">{{ __($blog->data_values->title) }}</h3>
			  <div class="mt-5">@php echo $blog->data_values->long_description @endphp</div>
			</div>
			<div class="blog-details-footer">
			  <span class="share-caption">@lang('SHARE POST')</span>
			  <ul class="share-post-links">
				<li><a class="facebook" href="https://www.facebook.com/sharer/sharer.php?u={{ urlencode(url()->current()) }}" target="_blank"><i class="fab fa-facebook-f"></i>@lang('Facebook')</a></li>
				<li><a class="twitter" href="https://twitter.com/intent/tweet?text=my share text&amp;url={{ urlencode(url()->current()) }}" target="_blank"><i class="fab fa-twitter"></i>@lang('Twitter')</a></li>
				<li><a class="pinterest" href="https://pinterest.com/pin/create/bookmarklet/?media={{ getImage('assets/images/frontend/blog/' . $blog->data_values->blog_image, '820x450') }}&url={{ urlencode(url()->current()) }}&is_video=[is_video]&description={{ $blog->data_values->title }}" target="_blank"><i class="fab fa-pinterest-p"></i>@lang('Pinterest')</a></li>
				<li><a class="linkedin " href="http://www.linkedin.com/shareArticle?mini=true&amp;url={{ urlencode(url()->current()) }}" target="_blank"><i class="fab fa-linkedin-in"></i>@lang('Linkedin')</a></li>
			  </ul>
			</div>
		  </div>
		  <div class="">
			<div class="fb-comments" data-href="{{ route('blog.details',[$blog->id,slug($blog->data_values->title)]) }}" data-numposts="5"></div>
		  </div>
		</div>

		<div class="col-lg-4 pl-lg-5">
		  <div class="sidebar">
			<div class="widget">
			  <h3 class="widget-title">@lang('Latest Blogs')</h3>
			  <ul class="small-post-list">
				@foreach ($latestBlogs as $latestBlog)
				<li class="small-single-post">
				  <div class="thumb"><img src="{{ getImage('assets/images/frontend/blog/thumb_' . $latestBlog->data_values->blog_image, '390x210') }}" alt="image"></div>
				  <div class="content">
					<h5 class="post-title"><a href="{{ route('blog.details', [slug($latestBlog->data_values->title), $latestBlog->id]) }}">{{ __($latestBlog->data_values->title) }}</a></h5>
					<ul class="post-meta">
					  <li><span>{{ showDateTime($latestBlog->created_at,'d M Y') }}</span></li>
					</ul>
				  </div>
				</li><!-- small-single-post end -->
				@endforeach
			  </ul>
			</div><!-- widget end -->
		  </div><!-- sidebar end -->
		</div>
	  </div>
	</div>
  </section>

@endsection
@push('fbComment')
	@php echo loadExtension('fb-comment') @endphp
@endpush
