@extends($activeTemplate.'layouts.frontend')
@section('content')
<section class="pt-120 pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12 text-center">
                @php
                $maintenanceContent = getContent('maintenance.content', true);
                @endphp
                <div>
                    <h2 class="text-danger">@lang('THE SITE IS UNDER MAINTENANCE')</h2>
                    <img class="maintainance-mode__img"
                        src="{{ getImage('assets/images/frontend/maintenance/' . @$maintenanceContent->data_values->image, '660x320') }}"
                        alt="">
                    <div class="text-white maintainance-mode__content">
                        @php echo $maintenance->data_values->description @endphp
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@push('script')
    <script>
        "use strict";
        (function ($) {
            $('header').remove();
            $('footer').remove();
            $('.inner-hero').remove();
        })(jQuery);
    </script>
@endpush

@push('style')
<style>
    body{
        display: flex;
        align-items: center;
        justify-content: center;
        min-height: 100vh;
    }
</style>
@endpush
