@php
   $testimonialContent = getContent('testimonial.content', true);
   $testimonialElements = getContent('testimonial.element', false);
@endphp

<section class="pt-120 pb-120 bg_img overlay--one" style="background-image: url('{{ getImage('assets/images/frontend/testimonial/' . $testimonialContent->data_values->background_image, '1600x900') }}');">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-lg-6 text-center">
          <div class="section-header">
            <h2 class="section-title text--base">{{ __($testimonialContent->data_values->heading) }}</h2>
            <p>{{ __($testimonialContent->data_values->subheading) }}</p>
          </div>
        </div>
      </div><!-- row end -->
      <div class="row">
        <div class="col-lg-12">
          <div class="testimonial-slider">
            @foreach ($testimonialElements as $element)
            <div class="single-slide">
              <div class="testimonial-card">
                <div class="testimonial-card__content">
                  <div class="ratings mb-2">
                    @for ($i = 0; $i < $element->data_values->Rating; $i++)
                        <i class="las la-star"></i>
                    @endfor
                  </div>
                  <p>{{ __($element->data_values->description) }}</p>
                </div>
                <div class="testimonial-card__client">
                  <div class="thumb">
                    <img src="{{ getImage('assets/images/frontend/testimonial/' . $element->data_values->client_image, '500x500') }}" alt="image">
                  </div>
                  <div class="content">
                    <h6 class="name">{{ __($element->data_values->client_name) }}</h6>
                    <span class="designation">{{ __($element->data_values->client_designation) }}</span>
                  </div>
                </div>
              </div><!-- testimonial-card end -->
            </div>
            @endforeach
          </div>
        </div>
      </div><!-- row end -->
    </div>
  </section>


  @push('style-lib')
  <link rel="stylesheet" href="{{ asset($activeTemplateTrue.'css/vendor/slick.css') }} ">
  @endpush

  @push('script-lib')
  <!-- slick slider js -->
  <script src="{{ asset($activeTemplateTrue.'js/vendor/slick.min.js') }}"></script>
  <script>
    // testimonial slider
    $('.testimonial-slider').slick({
      dots: true,
      infinite: true,
      speed: 300,
      slidesToShow: 3,
      slidesToScroll: 1,
      arrows: false,
      // autoplay: true,
      prevArrow: '<div class="prev"><i class="las la-angle-left"></i></div>',
      nextArrow: '<div class="next"><i class="las la-angle-right"></i></div>',
      responsive: [
        {
          breakpoint: 1200,
          settings: {
            slidesToShow: 2
          }
        },
        {
          breakpoint: 768,
          settings: {
            slidesToShow: 1
          }
        },
        {
          breakpoint: 576,
          settings: {
            slidesToShow: 1
          }
        }
      ]
    });
  </script>
  @endpush
