<?php
  $blogContent  = getContent('blog.content', true);
  $blogElements = getContent('blog.element', false, 3, true);
?>

<section class="pt-120 pb-120">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-xl-6 col-lg-8 text-center">
          <div class="section-header">
            <h2 class="section-title text--base"><?php echo e(__(@$blogContent->data_values->heading)); ?></h2>
            <p><?php echo e(__(@$blogContent->data_values->subheading)); ?></p>
          </div>
        </div>
      </div><!-- row end -->

      <div class="row justify-content-center mb-none-30">
        <?php $__currentLoopData = $blogElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-lg-4 col-md-6 mb-30 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                <div class="blog-card h-100">
                    <div class="blog-card__thumb">
                    <img src="<?php echo e(getImage('assets/images/frontend/blog/thumb_' . $blog->data_values->blog_image, '390x210')); ?>" alt="image">
                    </div>
                    <div class="blog-card__content">
                    <ul class="blog-card__meta d-flex flex-wrap mb-2">
                        <li>
                        <i class="las la-calendar"></i>
                        <span><?php echo e(showDateTime($blog->created_at,'d M Y')); ?></span>
                        </li>
                    </ul>
                    <h4 class="blog-card__title mb-4"><a href="<?php echo e(route('blog.details', [slug($blog->data_values->title), $blog->id])); ?>"><?php echo e(__($blog->data_values->title)); ?></a></h4>
                    <p><?php echo e(__($blog->data_values->short_description)); ?></p>
                    </div>
                </div>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </div>
</section>

<?php /**PATH /home/tradveia/public_html/core/resources/views/templates/basic/sections/blog.blade.php ENDPATH**/ ?>