<?php
   $subscribeContent = getContent('subscribe.content', true);
?>

<section class="pb-120 pt-120 section--bg">
    <div class="container">
      <div class="row justify-content-center mt-5">
        <div class="col-lg-10 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
          <div class="subscribe-wrapper bg_img">
            <div class="row align-items-center">
              <div class="col-lg-5">
                <h2 class="title"><?php echo e(__($subscribeContent->data_values->heading)); ?></h2>
              </div>
              <div class="col-lg-7 mt-lg-0 mt-4">
                <form class="subscribe-form" action="" method="POST">
                  <?php echo csrf_field(); ?>
                  <input type="email" name="email" class="form-control" placeholder="Email Address" required>
                  <button class="btn btn-md btn--base"><?php echo app('translator')->get('Subscribe'); ?></button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

<?php $__env->startPush('script'); ?>
<script>
    (function($) {
    "use strict"
    $(document).ready(function() {
    $('.subscribe-form').submit(function(event) {
        event.preventDefault(); // prevent the form from submitting through the browser

        // serialize the form data
        var formData = $(this).serialize();

        // send an Ajax request to the server
        $.ajax({
        type: 'POST',
        url: "<?php echo e(route('subscribe')); ?>",
        data: formData,
        success: function(response) {
            // handle a successful response
            $('input[name="email"]').val('');
            notify(response[0],response[1]);
        },
        error: function(xhr, status, error) {
            // handle an error response
            if (xhr.status === 422) {
            var errors = xhr.responseJSON.errors;
            // loop through the validation errors and display them
            $.each(errors, function(key, value) {
                notify('error',value[0]);
            });
            } else {
            console.log(xhr.responseText);
            }
        }
        });
    });
    });



    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/trad84539424/public_html/core/resources/views/templates/basic/sections/subscribe.blade.php ENDPATH**/ ?>