<?php $__env->startSection('content'); ?>
    <section class="pb-60 pt-60">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-md-12">
                    <div class="table-responsive--md">
                        <table class="table style--two">
                            <thead>
                                <tr>
                                    <th scope="col"><?php echo app('translator')->get('Plan'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Invested'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Will Recieve Interest'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Total'); ?></th>
                                    <th scope="col"><?php echo app('translator')->get('Get Return After'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $invests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <?php echo e(__($invest->plan->name)); ?><br>
                                            <?php echo e(showAmount($invest->amount)); ?> <?php echo e(__(curText())); ?>

                                        </td>
                                        <td>
                                            <?php echo app('translator')->get('For a'); ?> <?php echo e($invest->time_name); ?>

                                        </td>
                                        <td>
                                            <?php echo e(showAmount($invest->interest)); ?> <?php echo e(__(curText())); ?>

                                        </td>
                                        <td> <?php echo e(showAmount($invest->interest + $invest->amount)); ?> <?php echo e(__(curText())); ?> </td>

                                        <td scope="row" class="font-weight-bold">
                                            <?php if($invest->status == Status::INVEST_RUNNING): ?>
                                                <p id="counter<?php echo e($invest->id); ?>" class="demo countdown timess2 "></p>
                                                <?php
                                                    if ($invest->last_time) {
                                                        $start = $invest->last_time;
                                                    } else {
                                                        $start = $invest->created_at;
                                                    }
                                                ?>
                                                <div class="progress <?php if(Carbon\Carbon::parse($invest->next_time) > now()): ?> createCountDown <?php endif; ?>"
                                                    data-id="counter<?php echo e($invest->id); ?>"
                                                    data-seconds="<?php echo e(Carbon\Carbon::parse($invest->next_time)->diffInSeconds()); ?>"
                                                >
                                                    <div class="progress-bar progress-bar-striped bg-success" role="progressbar" style="width: <?php echo e(diffDatePercent($start, $invest->next_time)); ?>%" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100">
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <span class="badge badge--success"><?php echo app('translator')->get('Completed'); ?></span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($invests->hasPages()): ?>
                    <div class="card-footer">
                        <?php echo e(paginateLinks($invests)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<script>
    "use strict"

    function createCountDown(elementId, sec) {
        var tms = sec;
        var x = setInterval(function() {
            var distance = tms * 1000;
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            document.getElementById(elementId).innerHTML = days + "d: " + hours + "h " + minutes + "m " + seconds + "s ";
            if (distance < 0) {
                clearInterval(x);
                document.getElementById(elementId).innerHTML = "COMPLETE";
            }
            tms--;
        }, 1000);
    }

    $(document).ready(function() {
        var elements = $('.createCountDown');
        for (let i = 0; i < elements.length; i++) {
            var element = $(elements[i]);
            var data = element.data();
            createCountDown(data.id, data.seconds)
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/trad84539424/public_html/core/resources/views/templates/basic/user/invests.blade.php ENDPATH**/ ?>