<?php
   $faqContent = getContent('faq.content', true);
   $faqElements = getContent('faq.element', false);
?>

<section class="pt-120 pb-120">
    <div class="container">
      <div class="row justify-content-between mb-none-40">
        <div class="col-lg-5 mb-40 wow fadeInLeft" data-wow-duration="0.5s" data-wow-delay="0.3s">
          <h2 class="section-title text--base"><?php echo e(__($faqContent->data_values->heading)); ?></h2>
          <p><?php echo e(__($faqContent->data_values->subheading)); ?></p>
          <ul class="cmn-list mt-4">
            <li>
              <h5 class="text-white"><?php echo e(__($faqContent->data_values->service_one_heading)); ?></h5>
              <p class="para-white mt-2"><?php echo e(__($faqContent->data_values->service_one_subheading)); ?></p>
            </li>
            <li>
              <h5 class="text-white"><?php echo e(__($faqContent->data_values->service_two_heading)); ?></h5>
              <p class="para-white mt-2"><?php echo e(__($faqContent->data_values->service_two_subheading)); ?></p>
            </li>
          </ul>
        </div>
        <div class="col-lg-6 mb-40 wow fadeInRight" data-wow-duration="0.5s" data-wow-delay="0.5s">
          <div class="accordion cmn-accordion overflow-hidden" id="accordionExample">
            <?php $__currentLoopData = $faqElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="card">
              <div class="card-header" id="headingOne<?php echo e($loop->iteration); ?>">
                <h2 class="mb-0">
                  <button class="btn   w-100" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne<?php echo e($loop->iteration); ?>" <?php if($loop->first): ?> aria-expanded="true" <?php else: ?> aria-expanded="false" <?php endif; ?>  aria-controls="collapseOne<?php echo e($loop->iteration); ?>">
                    <i class="las la-question-circle"></i>
                    <span><?php echo e(__($element->data_values->question)); ?></span>
                  </button>
                </h2>
              </div>

              <div id="collapseOne<?php echo e($loop->iteration); ?>" class="collapse <?php if($loop->first): ?> show <?php endif; ?> " aria-labelledby="headingOne<?php echo e($loop->iteration); ?>" data-parent="#accordionExample">
                <div class="card-body">
                  <p><?php echo e(__($element->data_values->answer)); ?></p>
                </div>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
      </div>
    </div>
  </section>
<?php /**PATH /home/trad84539424/public_html/core/resources/views/templates/basic/sections/faq.blade.php ENDPATH**/ ?>