<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Numbers\V2\RegulatoryCompliance\Bundle;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class BundleCopyOptions {
    /**
     * @param string $friendlyName The string that you assigned to describe the
     *                             copied bundle
     * @return CreateBundleCopyOptions Options builder
     */
    public static function create(string $friendlyName = Values::NONE): CreateBundleCopyOptions {
        return new CreateBundleCopyOptions($friendlyName);
    }
}

class CreateBundleCopyOptions extends Options {
    /**
     * @param string $friendlyName The string that you assigned to describe the
     *                             copied bundle
     */
    public function __construct(string $friendlyName = Values::NONE) {
        $this->options['friendlyName'] = $friendlyName;
    }

    /**
     * The string that you assigned to describe the copied bundle.
     *
     * @param string $friendlyName The string that you assigned to describe the
     *                             copied bundle
     * @return $this Fluent Builder
     */
    public function setFriendlyName(string $friendlyName): self {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = \http_build_query(Values::of($this->options), '', ' ');
        return '[Twilio.Numbers.V2.CreateBundleCopyOptions ' . $options . ']';
    }
}