<?php

namespace App\Http\Controllers;

use App\Constants\Status;
use App\Lib\PlanInvest;
use App\Models\Invest;
use App\Models\Transaction;
use Carbon\Carbon;

class CronController extends Controller
{
    public function cron()
    {
        $now                = Carbon::now();
        $general            = gs();
        $general->last_cron = $now;
        $general->save();
        
        $invests = Invest::where('status', Status::INVEST_RUNNING)->where('next_time', '<=', $now)->orderBy('last_time')->take(100)->get();

        foreach ($invests as $invest) {

            $now  = $now;
            $user = $invest->user;

            $invest->paid               = $invest->interest;
            $invest->last_time          = time();
            $invest->status             = Status::INVEST_COMPLETED; // Change Status so he do not get any more return

            // Add Return Amount to user's Interest Balance
            $user->balance += $invest->interest;
            $user->save();

            $trx = getTrx();

            // Create The Transaction for Interest Back
            $transaction               = new Transaction();
            $transaction->user_id      = $user->id;
            $transaction->amount       = $invest->interest;
            $transaction->charge       = 0;
            $transaction->post_balance = $user->balance;
            $transaction->trx_type     = '+';
            $transaction->trx          = $trx;
            $transaction->remark       = 'interest';
            $transaction->details      = showAmount($invest->interest) . ' ' . curText() . ' interest from ' . @$invest->plan->name;
            $transaction->save();

            //Return back the capital
            $capital        = $invest->amount;
            $user->balance += $capital;
            $user->save();

            $transaction               = new Transaction();
            $transaction->user_id      = $user->id;
            $transaction->amount       = $capital;
            $transaction->charge       = 0;
            $transaction->post_balance = $user->balance;
            $transaction->trx_type     = '+';
            $transaction->trx          = $trx;
            $transaction->remark       = 'capital_return';
            $transaction->details      = showAmount($capital) . ' ' . curText() . ' capital back from ' . @$invest->plan->name;
            $transaction->save();

            // Give Referral Commission if Enabled
            if ($general->interest_commission == 1) {
                $commissionType = 'interest_commission';
                PlanInvest::levelCommission($user, $invest->interest, $commissionType, $trx);
            }

            $invest->save();

            notify($user, 'INTEREST', [
                'trx'          => $invest->trx,
                'amount'       => showAmount($invest->interest),
                'plan_name'    => @$invest->plan->name,
                'post_balance' => showAmount($user->balance),
            ]);
        }
    }
}
