<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\Searchable;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Plan extends Model
{
    use GlobalStatus, Searchable;

    public function invests()
    {
        return $this->hasMany(Invest::class);
    }

    public function scopeFeatured($query)
    {
        $query->where('featured', Status::ENABLE);
    }

    public function scopeActive($query)
    {
        return $query->where('status', Status::ENABLE);
    }

    public function time()
    {
        return $this->belongsTo(TimeSetting::class);
    }

    public function featuredBadge():Attribute
    {
        return new Attribute(function () {
            $html = '';
            if ($this->featured == Status::ENABLE) {
                $html = '<span class="badge badge--success">' . trans('Yes') . '</span>';
            } else {
                $html = '<span><span class="badge badge--dark">' . trans('No') . '</span></span>';
            }
            return $html;
        });
    }
}
