@php
  $blogContent  = getContent('blog.content', true);
  $blogElements = getContent('blog.element', false, 3, true);
@endphp

<section class="pt-120 pb-120">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-xl-6 col-lg-8 text-center">
          <div class="section-header">
            <h2 class="section-title text--base">{{ __(@$blogContent->data_values->heading) }}</h2>
            <p>{{ __(@$blogContent->data_values->subheading) }}</p>
          </div>
        </div>
      </div><!-- row end -->

      <div class="row justify-content-center mb-none-30">
        @foreach($blogElements as $blog)
            <div class="col-lg-4 col-md-6 mb-30 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
                <div class="blog-card h-100">
                    <div class="blog-card__thumb">
                    <img src="{{ getImage('assets/images/frontend/blog/thumb_' . $blog->data_values->blog_image, '390x210') }}" alt="image">
                    </div>
                    <div class="blog-card__content">
                    <ul class="blog-card__meta d-flex flex-wrap mb-2">
                        <li>
                        <i class="las la-calendar"></i>
                        <span>{{ showDateTime($blog->created_at,'d M Y') }}</span>
                        </li>
                    </ul>
                    <h4 class="blog-card__title mb-4"><a href="{{ route('blog.details', [slug($blog->data_values->title), $blog->id]) }}">{{ __($blog->data_values->title) }}</a></h4>
                    <p>{{ __($blog->data_values->short_description) }}</p>
                    </div>
                </div>
            </div>
          @endforeach
      </div>
    </div>
</section>

