@php
   $faqContent = getContent('faq.content', true);
   $faqElements = getContent('faq.element', false);
@endphp

<section class="pt-120 pb-120">
    <div class="container">
      <div class="row justify-content-between mb-none-40">
        <div class="col-lg-5 mb-40 wow fadeInLeft" data-wow-duration="0.5s" data-wow-delay="0.3s">
          <h2 class="section-title text--base">{{ __($faqContent->data_values->heading) }}</h2>
          <p>{{ __($faqContent->data_values->subheading) }}</p>
          <ul class="cmn-list mt-4">
            <li>
              <h5 class="text-white">{{ __($faqContent->data_values->service_one_heading) }}</h5>
              <p class="para-white mt-2">{{ __($faqContent->data_values->service_one_subheading) }}</p>
            </li>
            <li>
              <h5 class="text-white">{{ __($faqContent->data_values->service_two_heading) }}</h5>
              <p class="para-white mt-2">{{ __($faqContent->data_values->service_two_subheading) }}</p>
            </li>
          </ul>
        </div>
        <div class="col-lg-6 mb-40 wow fadeInRight" data-wow-duration="0.5s" data-wow-delay="0.5s">
          <div class="accordion cmn-accordion overflow-hidden" id="accordionExample">
            @foreach ($faqElements as $element)
            <div class="card">
              <div class="card-header" id="headingOne{{ $loop->iteration }}">
                <h2 class="mb-0">
                  <button class="btn   w-100" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne{{ $loop->iteration }}" @if ($loop->first) aria-expanded="true" @else aria-expanded="false" @endif  aria-controls="collapseOne{{ $loop->iteration }}">
                    <i class="las la-question-circle"></i>
                    <span>{{ __($element->data_values->question) }}</span>
                  </button>
                </h2>
              </div>

              <div id="collapseOne{{ $loop->iteration }}" class="collapse @if ($loop->first) show @endif " aria-labelledby="headingOne{{ $loop->iteration }}" data-parent="#accordionExample">
                <div class="card-body">
                  <p>{{ __($element->data_values->answer) }}</p>
                </div>
              </div>
            </div>
            @endforeach
          </div>
        </div>
      </div>
    </div>
  </section>
