@extends($activeTemplate . 'layouts.master')
@section('content')
<div class="container py-60">
    <div class="row gy-4">
        @if (auth()->user()->kv == 0)
        <div class="col-12">
            <div class="card custom--card">
                <div class="card-header">
                    <h4 class="text-danger">@lang('KYC Verification required')</h4>
                </div>
                <div class="card-body">
                    <p class="mb-0"> @php echo nl2br($kyc->data_values->kyc_required_message) @endphp <a class="text--base" href="{{ route('user.kyc.form') }}">@lang('Click Here to Verify')</a></p>
                </div>
            </div>
        </div>
        @endif
        
        @if (auth()->user()->kv == 2)
        <div class="col-12">
            <div class="card custom--card">
                <div class="card-header">
                   <h4 class="text-warning">@lang('KYC Verification pending')</h4>
                </div>
                <div class="card-body">
                    <p class="mb-0">@php echo nl2br($kyc->data_values->kyc_pending_message) @endphp <a class="text--base" href="{{ route('user.kyc.data') }}">@lang('See KYC Data')</a></p>
                </div>
            </div>
        </div>
        @endif
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.transactions') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['balance']) }}</h4>
                        <span class="caption">@lang('Wallet Balance')</span>
                    </div>
                    <div class="icon">
                        <i class="las la-wallet"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.deposit.history') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['total_deposit']) }}</h4>
                        <span class="caption">@lang('Total Deposit')</span>
                    </div>
                    <div class="icon">
                        <i class="fas fa-hand-holding-usd"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.withdraw.history') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['total_withdraw']) }}</h4>
                        <span class="caption">@lang('Total Withdraw')</span>
                    </div>
                    <div class="icon">
                        <i class="las la-cloud-download-alt"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.referrals') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['referral_commission']) }}</h4>
                        <span class="caption">@lang('Referral Earnings')</span>
                    </div>
                    <div class="icon">
                        <i class="las la-user-friends"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        
        <!--<div class="col-xl-3 col-sm-6">-->
        <!--    <a href="{{ route('user.invest.log') }}" class="widget-link h-100">-->
        <!--        <div class="d-widget d-flex flex-wrap align-items-center h-100">-->
        <!--            <div class="content">-->
        <!--                <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['total_invest']) }}</h4>-->
        <!--                <span class="caption">@lang('Total Invest')</span>-->
        <!--            </div>-->
        <!--            <div class="icon">-->
        <!--                <i class="las la-cubes "></i>-->
        <!--            </div>-->
        <!--        </div><!-- d-widget-two end -->-->
        <!--    </a>-->
        <!--</div>-->
        
        <div class="col-xl-3 col-sm-6">
            <a href="{{ route('user.invest.log') }}" class="widget-link h-100">
                <div class="d-widget d-flex flex-wrap align-items-center h-100">
                    <div class="content">
                        <h4 class="currency-amount">{{ curSym() }}{{ showAMount($data['total_running_invest']) }}</h4>
                        <span class="caption">@lang('Total Running Invest')</span>
                    </div>
                    <div class="icon">
                        <i class="las la-spinner"></i>
                    </div>
                </div><!-- d-widget-two end -->
            </a>
        </div>
        
        <!--<div class="col-xl-3 col-sm-6">-->
        <!--    <a href="{{ route('user.invest.log') }}" class="widget-link h-100">-->
        <!--        <div class="d-widget d-flex flex-wrap align-items-center h-100">-->
        <!--            <div class="content">-->
        <!--                <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['total_completed_invest']) }}</h4>-->
        <!--                <span class="caption">@lang('Total Invest Completed') </span>-->
        <!--            </div>-->
        <!--            <div class="icon">-->
        <!--                <i class="las la-list-alt"></i>-->
        <!--            </div>-->
        <!--        </div><!-- d-widget-two end -->-->
        <!--    </a>-->
        <!--</div>-->
        
        <!--<div class="col-xl-3 col-sm-6">-->
        <!--    <a href="{{ route('user.invest.log') }}" class="widget-link h-100">-->
        <!--        <div class="d-widget d-flex flex-wrap align-items-center h-100">-->
        <!--            <div class="content">-->
        <!--                <h4 class="currency-amount">{{ curSym() }}{{ showAmount($data['total_profit']) }}</h4>-->
        <!--                <span class="caption">@lang('Total Profit') +  <span class="badge badge--base">@lang('Capital')</span> </span>-->
        <!--            </div>-->
        <!--            <div class="icon">-->
        <!--                <i class="las la-money-bill-wave-alt"></i>-->
        <!--            </div>-->
        <!--        </div><!-- d-widget-two end -->-->
        <!--    </a>-->
        <!--</div>-->
        <div class="col-12" style="height: 800px !important">
           <!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container" style="height:100%;width:100%">
  <div class="tradingview-widget-container__widget" style="height:calc(100% - 32px);width:100%"></div>
  <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text"></span></a></div>
  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-advanced-chart.js" async>
  {
  "autosize": true,
  "symbol": "BITSTAMP:BTCUSD",
  "timezone": "America/New_York",
  "theme": "dark",
  "style": "1",
  "locale": "en",
  "backgroundColor": "rgba(255, 255, 255, 1)",
  "withdateranges": true,
  "range": "1M",
  "hide_side_toolbar": false,
  "allow_symbol_change": true,
  "watchlist": [
    "NYMEX:CL1!",
    "MCX:GOLD1!",
    "CME:6B1!",
    "ICEUS:CC1!",
    "BINANCE:BTCUSDT27M2025",
    "CBOT:ZL1!",
    "CBOT:ZB1!"
  ],
  "compareSymbols": [
    {
      "symbol": "ICEUS:SB1!",
      "position": "SameScale"
    },
    {
      "symbol": "COMEX:GC1!",
      "position": "SameScale"
    },
    {
      "symbol": "MCX:ALUMINIUM1!",
      "position": "SameScale"
    },
    {
      "symbol": "CMCMARKETS:SILVERN2025",
      "position": "SameScale"
    },
    {
      "symbol": "CAPITALCOM:ESM2025",
      "position": "SameScale"
    }
  ],
  "details": true,
  "hotlist": true,
  "studies": [
    "STD;24h%Volume",
    "STD;Accumulation_Distribution",
    "STD;Advance%1Decline%1Line",
    "STD;Advance%1Decline%1Ratio",
    "STD;Advance_Decline_Ratio_Bars",
    "STD;Arnaud%1Legoux%1Moving%1Average",
    "STD;Aroon",
    "STD;Average%Day%Range",
    "STD;Average%1Directional%1Index",
    "STD;Average_True_Range",
    "STD;Awesome_Oscillator",
    "STD;Balance%1of%1Power",
    "STD;BBTrend",
    "STD;Bollinger_Bands",
    "STD;Bollinger_Bands_B",
    "STD;Bollinger_Bands_Width",
    "STD;Bollinger%1Bars",
    "STD;Bull%Bear%Power",
    "STD;DEMA",
    "STD;ENV",
    "STD;Fisher_Transform",
    "STD;Gaps",
    "STD;Price%1Target",
    "PriceVolumeTrend@tv-basicstudies",
    "STD;ROC",
    "STD;Supertrend",
    "STD;Technical%1Ratings",
    "STD;Trading%1Sessions",
    "STD;Trend%1Strength%1Index",
    "STD;TRIX",
    "STD;Volume%1Delta",
    "STD;Vortex%1Indicator",
    "STD;Woodies%1CCI",
    "STD;Zig_Zag"
  ],
  "show_popup_button": true,
  "popup_width": "1000",
  "popup_height": "650",
  "support_host": "https://www.tradingview.com"
}
  </script>
</div>
<!-- TradingView Widget END -->
        </div>
        <div class="col-lg-12">
            <div class="table-responsive--md  table-responsive">
                <h4 class="mb-2 ms-1">@lang('Latest Transaction')</h4>
                <table class="table style--two">
                    <thead>
                        <tr>
                            <th>@lang('Trx')</th>
                            <th>@lang('Transacted')</th>
                            <th>@lang('Amount')</th>
                            <th>@lang('Post Balance')</th>
                            <th>@lang('Detail')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transactions as $trx)
                            <tr>
                                <td>
                                    <strong>{{ $trx->trx }}</strong>
                                </td>

                                <td>
                                    {{ showDateTime($trx->created_at) }}
                                </td>

                                <td class="budget">
                                    <span class="fw-bold @if ($trx->trx_type == '+') text-success @else text-danger @endif">
                                        {{ $trx->trx_type }} {{ showAmount($trx->amount) }} {{ curText() }}
                                    </span>
                                </td>

                                <td class="budget">
                                    {{ showAmount($trx->post_balance) }} {{ __(curText()) }}
                                </td>


                                <td>
                                    {{ __($trx->details) }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td class="text-muted text-center" colspan="100%">{{ __($emptyMessage) }}</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
        <br>
        <div class="col-lg-12">
         <!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container">
  <div class="tradingview-widget-container__widget"></div>
  <div class="tradingview-widget-copyright"><a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank"><span class="blue-text"></span></a></div>
  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-symbol-overview.js" async>
  {
  "symbols": [
    [
      "Google",
      "GOOGL|1D"
    ],
    [
      "Microsoft",
      "MSFT|1D"
    ],
    [
      "BINANCE:ADAUSDT|1D"
    ],
    [
      "BINANCE:BTCUSDT|1D"
    ],
    [
      "NASDAQ:TSLA|1D"
    ],
    [
      "NASDAQ:NVDA|1D"
    ],
    [
      "COINBASE:ETHUSD|1D"
    ]
  ],
  "chartOnly": false,
  "width": "100%",
  "height": "100%",
  "locale": "en",
  "colorTheme": "light",
  "autosize": true,
  "showVolume": true,
  "showMA": true,
  "hideDateRanges": false,
  "hideMarketStatus": false,
  "hideSymbolLogo": false,
  "scalePosition": "left",
  "scaleMode": "Logarithmic",
  "fontFamily": "-apple-system, BlinkMacSystemFont, Trebuchet MS, Roboto, Ubuntu, sans-serif",
  "fontSize": "10",
  "noTimeScale": false,
  "valuesTracking": "3",
  "changeMode": "price-and-percent",
  "chartType": "candlesticks",
  "maLineColor": "#2962FF",
  "maLineWidth": 1,
  "maLength": 9,
  "headerFontSize": "small",
  "lineType": 0,
  "dateRanges": [
    "1d|1",
    "1m|30",
    "3m|60",
    "12m|1D",
    "60m|1W",
    "all|1M"
  ],
  "upColor": "#22ab94",
  "downColor": "#f7525f",
  "borderUpColor": "#22ab94",
  "borderDownColor": "#f7525f",
  "wickUpColor": "#22ab94",
  "wickDownColor": "#f7525f"
}
  </script>
</div>
<!-- TradingView Widget END -->
        </div>
    </div>
</div>
@endsection
