@extends($activeTemplate . 'layouts.master')
@section('content')
    <section class="pb-60 pt-60">
        <div class="container">
            <div class="row justify-content-center mt-2">
                <div class="col-md-12">
                    <div class="table-responsive--md">
                        <table class="table style--two">
                            <thead>
                                <tr>
                                    <th scope="col">@lang('Plan')</th>
                                    <th scope="col">@lang('Invested')</th>
                                    <th scope="col">@lang('Will Recieve Interest')</th>
                                    <th scope="col">@lang('Total')</th>
                                    <th scope="col">@lang('Get Return After')</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($invests as $invest)
                                    <tr>
                                        <td>
                                            {{ __($invest->plan->name) }}<br>
                                            {{ showAmount($invest->amount) }} {{ __(curText()) }}
                                        </td>
                                        <td>
                                            @lang('For a') {{ $invest->time_name }}
                                        </td>
                                        <td>
                                            {{ showAmount($invest->interest) }} {{ __(curText()) }}
                                        </td>
                                        <td> {{ showAmount($invest->interest + $invest->amount) }} {{ __(curText()) }} </td>

                                        <td scope="row" class="font-weight-bold">
                                            @if ($invest->status == Status::INVEST_RUNNING)
                                                <p id="counter{{ $invest->id }}" class="demo countdown timess2 "></p>
                                                @php
                                                    if ($invest->last_time) {
                                                        $start = $invest->last_time;
                                                    } else {
                                                        $start = $invest->created_at;
                                                    }
                                                @endphp
                                                <div class="progress @if (Carbon\Carbon::parse($invest->next_time) > now()) createCountDown @endif"
                                                    data-id="counter{{ $invest->id }}"
                                                    data-seconds="{{Carbon\Carbon::parse($invest->next_time)->diffInSeconds() }}"
                                                >
                                                    <div class="progress-bar progress-bar-striped bg-success" role="progressbar" style="width: {{ diffDatePercent($start, $invest->next_time) }}%" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100">
                                                    </div>
                                                </div>
                                            @else
                                                <span class="badge badge--success">@lang('Completed')</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="100%" class="text-center">{{ __($emptyMessage) }}</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                @if ($invests->hasPages())
                    <div class="card-footer">
                        {{ paginateLinks($invests) }}
                    </div>
                @endif
            </div>
        </div>
    </section>
@endsection

@push('script')
<script>
    "use strict"

    function createCountDown(elementId, sec) {
        var tms = sec;
        var x = setInterval(function() {
            var distance = tms * 1000;
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);
            document.getElementById(elementId).innerHTML = days + "d: " + hours + "h " + minutes + "m " + seconds + "s ";
            if (distance < 0) {
                clearInterval(x);
                document.getElementById(elementId).innerHTML = "COMPLETE";
            }
            tms--;
        }, 1000);
    }

    $(document).ready(function() {
        var elements = $('.createCountDown');
        for (let i = 0; i < elements.length; i++) {
            var element = $(elements[i]);
            var data = element.data();
            createCountDown(data.id, data.seconds)
        }
    });
</script>
@endpush
