<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10 ">
                <div class="card-body p-0">
                    <div class="table-responsive--md  table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Invest Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Interest'); ?></th>
                                    <th><?php echo app('translator')->get('Time'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Featured'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e(__($plan->name)); ?></td>
                                        <td>
                                            <span><?php echo e(curSym()); ?><?php echo e(showAmount($plan->fixed_amount)); ?></span>
                                        </td>
                                        <td> <?php echo e(showAmountTwoDigit($plan->interest)); ?>% </td>
                                        <td><?php echo e(__($plan->time->name)); ?></td>
                                        <td> <?php echo $plan->statusBadge; ?> </td>
                                        <td> <?php echo $plan->featuredBadge; ?> </td>
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-sm btn-outline--primary modalShow me-2" data-type="edit" data-bs-toggle="modal" data-bs-target="#planModal" data-resource="<?php echo e($plan); ?>" data-action="<?php echo e(route('admin.plan.update', $plan->id)); ?>"><i class="las la-pen"></i><?php echo app('translator')->get('Edit'); ?></button>
                                                <?php if($plan->status): ?>
                                                    <button class="btn btn-sm btn-outline--danger confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to disable this plan?'); ?>" data-action="<?php echo e(route('admin.plan.status', $plan->id)); ?>"><i class="las la-eye-slash"></i><?php echo app('translator')->get('Disable'); ?></button>
                                                <?php else: ?>
                                                    <button class="btn btn-sm btn-outline--success confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure to enable this plan?'); ?>" data-action="<?php echo e(route('admin.plan.status', $plan->id)); ?>"><i class="las la-eye"></i><?php echo app('translator')->get('Enable'); ?></button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="planModal">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Name'); ?></label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        <div class="form-group">
                            <label class="required"><?php echo app('translator')->get('Invest Amount'); ?></label>
                            <div class="input-group">
                                <input type="number" step="any" class="form-control" name="amount" value="" required>
                                <span class="input-group-text"><?php echo e(curText()); ?></span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Interest'); ?></label>
                            <div class="input-group">
                                <input type="number" step="any" class="form-control" name="interest" required>
                                <span class="input-group-text">%</span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Time'); ?></label>
                            <select name="time_id" class="form-control" required>
                                <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                <?php $__currentLoopData = $times; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $time): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($time->id); ?>"><?php echo e(__($time->name)); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Featured'); ?></label>
                            <input type="checkbox" data-width="100%" data-size="large" data-onstyle="-success" data-offstyle="-danger" data-bs-toggle="toggle" data-height="35" data-on="<?php echo app('translator')->get('Featured'); ?>" data-off="<?php echo app('translator')->get('Not Featured'); ?>" name="featured" checked>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn--primary w-100 h-45"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php if (isset($component)) { $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b = $component; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\ConfirmationModal::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b)): ?>
<?php $component = $__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b; ?>
<?php unset($__componentOriginalc51724be1d1b72c3a09523edef6afdd790effb8b); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button class="btn btn-outline--primary btn-sm modalShow" data-type="add" data-bs-toggle="modal" data-bs-target="#planModal" data-action="<?php echo e(route('admin.plan.store')); ?>">
        <i class="las la-plus"></i> <?php echo app('translator')->get('Add New'); ?>
    </button>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"

            $('.modalShow').on('click', function() {
                var btn = $(this);
                var modal = $('#planModal');
                var resource = btn.data('resource');
                var action = btn.data('action');

                modal.find('form')[0].reset();
                modal.find('form').attr('action', btn.data('action'));

                if ($(this).data('type') == 'edit') {
                    modal.find('[name=name]').val(resource.name);
                    modal.find('[name=amount]').val(parseFloat(resource.fixed_amount));
                    modal.find('[name=interest]').val(parseFloat(resource.interest));
                    modal.find('[name=time_id]').val(resource.time_id);
                    modal.find('[name="featured"]').bootstrapToggle(resource.featured == 1 ? "on" : "off" );
                    modal.find('.modal-title').text(`<?php echo app('translator')->get('Edit Plan'); ?>`);
                } else {
                    modal.find('.modal-title').text(`<?php echo app('translator')->get('Add New Plan'); ?>`);
                }
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/trad84539424/public_html/core/resources/views/admin/plan/index.blade.php ENDPATH**/ ?>