<div class="modal fade" id="investModal">
    <div class="modal-dialog modal-dialog-centered modal-content-bg">
        <div class="modal-content">
            <div class="modal-header">
                <?php if(auth()->check()): ?>
                    <strong class="modal-title" id="ModalLabel">
                        <?php echo app('translator')->get('Confirm to invest on'); ?> <span class="planName"></span>
                    </strong>
                <?php else: ?>
                    <strong class="modal-title" id="ModalLabel"> <?php echo app('translator')->get('At first sign in your account'); ?> </strong>
                <?php endif; ?>
                <button type="button" class="close bg--base-2" data-bs-dismiss="modal" aria-label="Close">
                    <i class="las la-times"></i>
                </button>
            </div>

            <form action="<?php echo e(route('user.invest.submit')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="plan_id">
                <?php if(auth()->check()): ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <h6 class="text-center investAmountRange"></h6>
                            <p class="text-center mt-1 interestDetails"></p>
                            <label><?php echo app('translator')->get('Select Wallet'); ?></label>
                            <select class="form-control form--control" name="wallet_type" required>
                                <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                <?php if(auth()->user()->balance > 0): ?>
                                    <option value="balance"><?php echo app('translator')->get('Balance - ' . curSym() . showAmount(auth()->user()->balance)); ?></option>
                                <?php endif; ?>
                                <?php $__currentLoopData = $gatewayCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($data->id); ?>" <?php if(old('wallet_type') == $data->method_code): echo 'selected'; endif; ?> data-gateway="<?php echo e($data); ?>"><?php echo e($data->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Invest Amount'); ?></label>
                            <div class="input-group">
                                <input type="number" step="any" class="form-control form--control" name="amount" required>
                                <span class="input-group-text"><?php echo e(curText()); ?></span>
                            </div>
                            <code class="gateway-info d-none"><?php echo app('translator')->get('Charge'); ?>: <span class="charge"></span> <?php echo e(curText()); ?>. <?php echo app('translator')->get('Total amount'); ?>: <span class="total"></span> <?php echo e(curText()); ?>.  <?php echo app('translator')->get('Limit'); ?> <span class="min_amount"></span>-<span class="max_amount"></span> <span class="g-currency"></span>
                            </code>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="modal-footer">
                    <?php if(auth()->check()): ?>
                        <button type="button" class="btn btn-dark btn-md" data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                        <button type="submit" class="btn btn--base btn-md"><?php echo app('translator')->get('Yes'); ?></button>
                    <?php else: ?>
                        <a href="<?php echo e(route('user.login')); ?>" class="btn btn--base btn-md w-100 text-center"><?php echo app('translator')->get('At first sign in your account'); ?></a>
                    <?php endif; ?>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        var symbol = '<?php echo e(curSym()); ?>';
        var currency = '<?php echo e(curText()); ?>';
    </script>
    <script src="<?php echo e(asset('assets/global/js/plans.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/tradveia/public_html/core/resources/views/templates/basic/partials/plans_modal.blade.php ENDPATH**/ ?>