<?php
    $footerContent  = getContent('footer.content', true);
    $footerElements = getContent('footer.element',orderById:true);
    $policyPages    = getContent('policy_pages.element', orderById: true);
    $contact        = getContent('contact_us.content', true);
?>
  <!-- TradingView Widget BEGIN -->
<div class="tradingview-widget-container" style="position: fixed; bottom: 0; left: 0; width: 100%; z-index: 9999; background-color: transparent;">
  <div class="tradingview-widget-container__widget"></div>
  <div class="tradingview-widget-copyright">
    <a href="https://www.tradingview.com/" rel="noopener nofollow" target="_blank">
      <span class="blue-text"></span>
    </a>
  </div>
  <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-ticker-tape.js" async>
  {
    "symbols": [
      {
        "proName": "FOREXCOM:SPXUSD",
        "title": "S&P 500 Index"
      },
      {
        "proName": "FOREXCOM:NSXUSD",
        "title": "US 100 Cash CFD"
      },
      {
        "proName": "FX_IDC:EURUSD",
        "title": "EUR to USD"
      },
      {
        "proName": "BITSTAMP:BTCUSD",
        "title": "Bitcoin"
      },
      {
        "proName": "BITSTAMP:ETHUSD",
        "title": "Ethereum"
      }
    ],
    "showSymbolLogo": true,
    "isTransparent": true,
    "displayMode": "adaptive",
    "colorTheme": "dark",
    "locale": "en"
  }
  </script>
</div>

<!-- TradingView Widget END --> 
<footer class="footer">
    <div class="footer__top">
        <div class="container">
            <div class="row mb-none-50">
                
                
                <div class="col-lg-3 mb-50">
                    <div class="footer-widget">
                        
                    </div><!-- footer-widget end -->
                </div>
                
                
                <div class="col-lg-3 mb-50">
                    <div class="footer-widget">
                        <a href="<?php echo e(route('home')); ?>" class="footer-logo"><img src="<?php echo e(getImage(getFilePath('logoIcon').'/logo.png')); ?>" alt="image"></a>
                        <p class="para-white mt-4 font-size--14px"><?php echo e(__($footerContent->data_values->description)); ?></p>
                    </div><!-- footer-widget end -->
                </div>
                <div class="col-lg-3 col-sm-6 mb-50">
                    <div class="footer-widget">
                        <h6 class="footer-widget__title"><?php echo app('translator')->get('Importants Links'); ?></h6>
                        <ul class="footer-menu-list">
                            <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('policy.pages', [slug($policy->data_values->title), $policy->id])); ?>"><?php echo e(__($policy->data_values->title)); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div><!-- footer-widget end -->
                </div>
                <div class="col-lg-3 col-sm-6 mb-50">
                    <div class="footer-widget">
                        <h6 class="footer-widget__title"><?php echo app('translator')->get('Site Links'); ?></h6>
                        <ul class="footer-menu-list">
                            <li><a href="<?php echo e(route('blogs')); ?>"><?php echo app('translator')->get('Blogs'); ?></a></li>
                            <li><a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a></li>
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                        </ul>
                    </div><!-- footer-widget end -->
                </div>
                <div class="col-lg-3 mb-50">
                    <div class="footer-widget">
                        <h6 class="footer-widget__title"><?php echo app('translator')->get('Contact'); ?></h6>
                        <p class="para-white font-size--14px"><?php echo e(__($footerContent->data_values->contact_description)); ?></p>
                        <ul class="footer-social-links d-flex align-items-center mt-3">
                            <?php $__currentLoopData = $footerElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $footer_element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <a href="<?php echo e($footer_element->data_values->url); ?>" target="_blank">
                                        <?php echo $footer_element->data_values->social_icon ?>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div><!-- footer-widget end -->
                </div>
                
                
                
                
             
            </div>
        </div>
    </div><!-- footer__top end -->
    <div class="footer__bottom">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 text-center">
                    <p class="para-white"><?php echo app('translator')->get('Copyright'); ?> <?php echo app('translator')->get('©'); ?> <?php echo e(date('Y')); ?> . <?php echo app('translator')->get('All Rights Reserved'); ?>.</p>
                </div>
            </div>
        </div>
    </div><!-- footer__bottom end -->
</footer>
<script src="//code.tidio.co/2m7vrbvystpal1le7q5amjbmnjvf60vw.js" async></script><?php /**PATH /home/trad84539424/public_html/core/resources/views/templates/basic/partials/footer.blade.php ENDPATH**/ ?>