<?php
    $plans           = \App\Models\Plan::active()->with('time')->featured()->orderBy('fixed_amount', 'ASC');
    $plansContent    = getContent('plans.content', true);
    $gatewayCurrency = null;

    if (auth()->check()) {
        $gatewayCurrency = App\Models\GatewayCurrency::whereHas('method', function ($gate) {
            $gate->where('status', Status::ENABLE);
        })
        ->with('method')
        ->orderby('method_code')
        ->get();
    }
?>
<section class="pt-120 pb-120">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6 text-center">
                <div class="section-header pb-60">
                    <h2 class="section-title text--base"><?php echo e(__($plansContent->data_values->heading)); ?></h2>
                    <p><?php echo e(__($plansContent->data_values->subheading)); ?></p>
                </div>
            </div>
        </div>
        <?php echo $__env->make($activeTemplate.'partials.plans', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
</section>

<?php echo $__env->make($activeTemplate.'partials.plans_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php /**PATH /home/tradveia/public_html/core/resources/views/templates/basic/sections/plans.blade.php ENDPATH**/ ?>