<?php
   $aboutContent = getContent('about.content', true);
   $aboutElements = getContent('about.element', false,orderById:true);
?>

<section class="about-section pt-120 pb-120 bg_img overlay--two" style="background-image: url('<?php echo e(getImage('assets/images/frontend/about/' . $aboutContent->data_values->background_image, '1600x680')); ?>');">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-6">
          <div class="section-header">
            <h2 class="section-title text--base"><?php echo e(__(@$aboutContent->data_values->heading)); ?></h2>
            <p><?php echo e(__(@$aboutContent->data_values->subheading)); ?></p>
          </div>
          <div class="row mb-none-30">
            <?php $__currentLoopData = $aboutElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-xl-8 mb-30 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.3s">
              <div class="info-card">
                <div class="info-card__icon">
                    <?php echo $element->data_values->icon ?>
                </div>
                <div class="info-card__content">
                  <h3 class="title"><?php echo e(__($element->data_values->title)); ?></h3>
                  <p class="mt-2"><?php echo e(__($element->data_values->description)); ?></p>
                </div>
              </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
        <div class="col-lg-6">
          <div class="abount-video text-center">
            <a href="<?php echo e(__($aboutContent->data_values->youtube_embed_url)); ?>" data-rel="lightcase:myCollection" class="video-button"><i class="las la-play"></i></a>
          </div>
        </div>
      </div>
    </div>
  </section>


  <?php $__env->startPush('style-lib'); ?>
  <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lightcase.css')); ?> ">
  <?php $__env->stopPush(); ?>

  <?php $__env->startPush('script-lib'); ?>
  <script src="<?php echo e(asset($activeTemplateTrue.'js/vendor/lightcase.min.js')); ?>"></script>
  <script>
    $('a[data-rel^=lightcase]').lightcase();
  </script>
  <?php $__env->stopPush(); ?>
<?php /**PATH /home/tradveia/public_html/core/resources/views/templates/basic/sections/about.blade.php ENDPATH**/ ?>