<?php
   $topInvestorContent = getContent('top_investor.content', true);
   $topInvestorElements = getContent('top_investor.element', false)->sortByDesc('data_values.investment_amount');
?>

<section class="pt-120 pb-120">
    <div class="container">
      <div class="row justify-content-center">
        <div class="col-xl-6 col-lg-8 text-center">
          <div class="section-header">
            <h2 class="section-title text--base"><?php echo e(__($topInvestorContent->data_values->heading)); ?></h2>
            <p><?php echo e(__($topInvestorContent->data_values->subheading)); ?></p>
          </div>
        </div>
      </div><!-- row end -->
      <div class="row justify-content-center mb-none-30">
        <?php $__currentLoopData = $topInvestorElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-xl-2 col-md-4 col-sm-6 mb-30 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.1s">
          <div class="investor-card">
            <div class="investor-card__thumb">
              <img src="<?php echo e(getImage('assets/images/frontend/top_investor/' . $element->data_values->client_image, '500x500')); ?>" alt="image">
            </div>
            <div class="investor-card__content">
              <h6 class="name"><?php echo e(__($element->data_values->client_name)); ?></h6>
              <span class="amount f-size-14"><?php echo app('translator')->get('Investment'); ?> - <?php echo e(curSym()); ?><?php echo e(__($element->data_values->investment_amount)); ?></span>
            </div>
          </div><!-- investor-card end -->
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    </div>
  </section>
<?php /**PATH /home/tradveia/public_html/core/resources/views/templates/basic/sections/top_investor.blade.php ENDPATH**/ ?>