<?php
   $contactContent = getContent('contact_us.content', true);
?>

<div class="header__top">
    <div class="container">
      <div class="row">
        <div class="col-md-6">
          <ul class="header-info-list justify-content-md-start justify-content-center">
            <li>
              <a href="tel:<?php echo e($contactContent->data_values->phone); ?>"><i class="las la-headset"></i> <?php echo e($contactContent->data_values->phone); ?></a>
            </li>
            <li>
              <a href="mailto:<?php echo e($contactContent->data_values->email); ?>"><i class="las la-envelope"></i> <?php echo e($contactContent->data_values->email); ?></a>
            </li>
          </ul>
        </div>
        <div class="col-md-6">
          <div class="d-flex justify-content-md-end justify-content-center align-items-center">
            <?php if($general->multi_language): ?>
            <select class="language-select mr-3 langSel d-none d-md-block">
              <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <option value="<?php echo e($item->code); ?>" <?php if(session('lang')==$item->code): ?> selected <?php endif; ?>><?php echo e(__($item->name)); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php endif; ?>

            <?php if(auth()->guard()->guest()): ?>
            <ul class="header-info-list justify-content-end">
              <li class="d-none d-md-block">
                <a href="<?php echo e(route('user.login')); ?>"><i class="las la-user"></i> <?php echo app('translator')->get('Login'); ?> </a>
              </li>
              <?php if($general->registration): ?>
              <li class="d-none d-md-block">
                <a href="<?php echo e(route('user.register')); ?>"><i class="las la-sign-in-alt"></i> <?php echo app('translator')->get('Registration'); ?> </a>
              </li>
              <?php endif; ?>
            </ul>
            <?php else: ?>
            <ul class="header-info-list justify-content-end">
                <li>
                  <a href="<?php echo e(route('user.logout')); ?>"><i class="las la-sign-out-alt"></i> <?php echo app('translator')->get('Logout'); ?> </a>
                </li>
            </ul>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
<?php /**PATH /home/tradveia/public_html/core/resources/views/templates/basic/partials/top_header.blade.php ENDPATH**/ ?>