<?php
    $profitCalculatorContent = getContent('profit_calculator.content', true);
    $plans = App\Models\Plan::active()->get();
?>
    <section class="calculator-section pt-120 pb-120">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-6 pe-lg-5">
                    <h2 class="section-title text--base"><?php echo e(__(@$profitCalculatorContent->data_values->heading)); ?></h2>
                    <p class="mt-2"><?php echo e(__(@$profitCalculatorContent->data_values->subheading)); ?></p>
                    <ul class="cmn-list mt-4">
                        <li>
                            <h5 class="text-white"><?php echo e(__(@$profitCalculatorContent->data_values->service_one_title)); ?></h5>
                            <p class="para-white mt-2"><?php echo e(__(@$profitCalculatorContent->data_values->subheading)); ?></p>
                        </li>
                        <li>
                            <h5 class="text-white"><?php echo e(__(@$profitCalculatorContent->data_values->service_two_title)); ?></h5>
                            <p class="para-white mt-2"><?php echo e(__(@$profitCalculatorContent->data_values->subheading)); ?></p>
                        </li>
                    </ul>
                </div>
                <div class="col-lg-6">
                    <div class="calculator-box">
                        <h2 class="calculator-box__title"><?php echo app('translator')->get('Calculate Your Profit'); ?></h3>
                            <div class="calculator-box__calculate">
                                <div class="form-group">
                                    <label for="invest"><?php echo app('translator')->get('Plans'); ?></label>
                                    <select name="plan_id">
                                        <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option data-plan="<?php echo e($plan); ?>"><?php echo e($plan->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="form-group">
                                    <label for="invest"><?php echo app('translator')->get('You Invest'); ?></label>
                                    <div class="input--group">
                                        <input type="number" step="any" name="invest" placeholder="You Invest" class="form-control" value="<?php echo e(showAmount($plans->first()->fixed_amount)); ?>" id="invest" readonly="readonly">
                                        <span class="input-icon"><i class="fab fa-bitcoin"></i></span>
                                    </div>
                                </div>
                            </div>
                            <div class="calculator-box__content">
                                <div class="calculator-widget-wrapper">
                                    <div class="calculator-widget">
                                        <div class="calculator-widget__icon">
                                            <img src="<?php echo e(asset($activeTemplateTrue.'images/profit_calculator/business-and-finance.svg')); ?>" alt="">
                                        </div>
                                        <div class="calculator-widget__content">
                                            <span class="calculator-widget__title"><?php echo app('translator')->get('Invest'); ?></span>
                                            <h4 class="fixed-type"><?php echo e(curSym()); ?><span class="fixed_amo"><?php echo e(showAmount($plans->first()->fixed_amount)); ?></h4>
                                        </div>
                                    </div>
                                    <div class="calculator-widget">
                                        <div class="calculator-widget__icon">
                                            <img src="<?php echo e(asset($activeTemplateTrue.'images/profit_calculator/return-on-investment.svg')); ?>" alt="">
                                        </div>
                                        <div class="calculator-widget__content">
                                            <span class="calculator-widget__title"><?php echo app('translator')->get('With Capital'); ?></span>
                                            <h4 class="calculator-widget__amount"><?php echo app('translator')->get('Yes'); ?></h4>
                                        </div>
                                    </div>
                                    <div class="calculator-widget">
                                        <div class="calculator-widget__icon">
                                            <img src="<?php echo e(asset($activeTemplateTrue.'images/profit_calculator/profits.svg')); ?>" alt="">
                                        </div>
                                        <div class="calculator-widget__content">
                                            <span class="calculator-widget__title"><?php echo app('translator')->get('Net profit'); ?></span>
                                            <h4 class="calculator-widget__amount net_profit"><?php echo e(curSym()); ?><?php echo e(showAmount(($plans->first()->fixed_amount * $plans->first()->interest) / 100)); ?></h4>
                                        </div>
                                    </div>
                                    <div class="calculator-widget">
                                        <div class="calculator-widget__icon">
                                            <img src="<?php echo e(asset($activeTemplateTrue.'images/profit_calculator/profit.svg')); ?>" alt="">
                                        </div>
                                        <div class="calculator-widget__content">
                                            <span class="calculator-widget__title"><?php echo app('translator')->get('Total Income'); ?></span>
                                            <h4 class="calculator-widget__amount total_profit"><?php echo e(curSym()); ?><?php echo e(showAmount(($plans->first()->fixed_amount * $plans->first()->interest) / 100 + $plans->first()->fixed_amount)); ?></h4>
                                        </div>
                                    </div>
                                </div>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php $__env->startPush('script'); ?>
        <script>

            function makeDecimal(number) {
                var strippedValue = number.toFixed("<?php echo e($general->allow_decimal_after_number); ?>");
                return strippedValue;
            }



            $('select[name="plan_id"]').change(function(e) {
                var plan = $(this).find(':selected').data('plan');

                var amount = parseFloat(plan.fixed_amount);
                var interestPercentage = parseFloat(plan.interest);
                var interest = (amount * interestPercentage) / 100;
                total = amount + interest;

                amount = makeDecimal(amount);
                interest = makeDecimal(interest);
                total = makeDecimal(total);


                $('input[name="invest"]').val(amount)
                $('.fixed_amo').text(amount)
                $('.net_profit').text("<?php echo e(curSym()); ?>" + interest)
                $('.total_profit').text("<?php echo e(curSym()); ?>" + total)
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php /**PATH /home/tradveia/public_html/core/resources/views/templates/basic/sections/profit_calculator.blade.php ENDPATH**/ ?>